import flet as ft


def main(page: ft.Page):
    page.title = "1.5 Цвета"
    page.padding = 20

    # 1. Hex цвет
    c_hex = ft.Container(
        width=100,
        height=100,
        bgcolor="#ff0000",  # красный
        content=ft.Text("#ff0000", color=ft.Colors.WHITE, size=12),
        alignment=ft.alignment.center,
    )

    # 2. Именованный цвет через ft.Colors
    c_named = ft.Container(
        width=100,
        height=100,
        bgcolor=ft.Colors.YELLOW,  # жёлтый
        content=ft.Text("ft.Colors.YELLOW", size=10, text_align=ft.TextAlign.CENTER),
        alignment=ft.alignment.center,
    )

    # 3. Оттенок палитры
    c_palette = ft.Container(
        width=100,
        height=100,
        bgcolor=ft.Colors.GREEN_200,  # светло-зелёный оттенок палитры
        content=ft.Text("GREEN_200", size=12),
        alignment=ft.alignment.center,
    )

    # 4. Прозрачность через with_opacity
    color_half_red = ft.Colors.with_opacity(0.5, ft.Colors.RED)
    c_opacity = ft.Container(
        width=100,
        height=100,
        bgcolor=color_half_red,
        content=ft.Text("RED 50%", color=ft.Colors.WHITE, size=12),
        alignment=ft.alignment.center,
    )

    page.add(
        ft.Text("1.5 Цвета", size=22, weight="bold"),
        ft.Text("Hex, именованные цвета, палитры и прозрачность."),
        ft.Divider(),
        ft.Row([c_hex, c_named, c_palette, c_opacity], spacing=10),
    )


if __name__ == "__main__":
    ft.app(target=main)
